/*
 * Decompiled with CFR 0.152.
 */
package com.floragunn.searchguard.enterprise.femt.datamigration880.service;

import com.floragunn.codova.documents.DocNode;
import com.floragunn.codova.documents.Document;
import com.floragunn.fluent.collections.ImmutableList;
import com.floragunn.fluent.collections.ImmutableMap;
import com.floragunn.fluent.collections.OrderedImmutableMap;
import com.floragunn.searchguard.enterprise.femt.datamigration880.service.ExecutionStatus;
import com.floragunn.searchguard.enterprise.femt.datamigration880.service.MappingTypes;
import com.floragunn.searchguard.enterprise.femt.datamigration880.service.OptimisticLock;
import com.floragunn.searchguard.enterprise.femt.datamigration880.service.StepExecutionSummary;
import java.time.Duration;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.ZoneOffset;
import java.time.temporal.TemporalAccessor;
import java.util.Objects;
import javax.annotation.Nullable;
import org.elasticsearch.common.time.DateFormatter;

public record MigrationExecutionSummary(LocalDateTime startTime, ExecutionStatus status, @Nullable String tempIndexName, @Nullable String backupIndexName, ImmutableList<StepExecutionSummary> stages, @Nullable OptimisticLock lockData) implements Document<MigrationExecutionSummary>
{
    private static final Duration DURATION_AGE_THRESHOLD = Duration.parse("PT15M");
    private static final DateFormatter DATE_FORMATTER = DateFormatter.forPattern((String)"strict_date_time").withZone((ZoneId)ZoneOffset.UTC);
    public static final String FIELD_START_TIME = "start_time";
    public static final String FIELD_STATUS = "status";
    public static final String FIELD_TEMP_INDEX_NAME = "temp_index_name";
    public static final String FIELD_BACKUP_INDEX_NAME = "backup_index_name";
    public static final String FIELD_STAGES = "stages";
    public static final ImmutableMap<String, Object> MAPPING = ImmutableMap.of((Object)"dynamic", (Object)true, (Object)"properties", (Object)ImmutableMap.of((Object)"start_time", MappingTypes.MAPPING_DATE, (Object)"status", MappingTypes.MAPPING_KEYWORD, (Object)"temp_index_name", MappingTypes.MAPPING_KEYWORD, (Object)"backup_index_name", MappingTypes.MAPPING_KEYWORD, (Object)"stages", StepExecutionSummary.MAPPING));

    public MigrationExecutionSummary {
        Objects.requireNonNull(startTime, "Start time is required");
        Objects.requireNonNull(status, "Status is required");
        Objects.requireNonNull(stages, "Stages list is required");
    }

    public MigrationExecutionSummary(LocalDateTime startTime, ExecutionStatus status, @Nullable String tempIndexName, @Nullable String backupIndexName, ImmutableList<StepExecutionSummary> stages) {
        this(startTime, status, tempIndexName, backupIndexName, stages, null);
    }

    public static MigrationExecutionSummary parse(DocNode docNode, Long primaryTerm, Long seqNo) {
        Objects.requireNonNull(docNode, "Doc node is require to parse data migration summary.");
        LocalDateTime startTime = LocalDateTime.from(DATE_FORMATTER.parse(docNode.getAsString(FIELD_START_TIME)));
        ExecutionStatus status = ExecutionStatus.valueOf(docNode.getAsString(FIELD_STATUS).toUpperCase());
        ImmutableList stages = docNode.getAsListOfNodes(FIELD_STAGES).map(StepExecutionSummary::parse);
        return new MigrationExecutionSummary(startTime, status, docNode.getAsString(FIELD_TEMP_INDEX_NAME), docNode.getAsString(FIELD_BACKUP_INDEX_NAME), (ImmutableList<StepExecutionSummary>)stages, new OptimisticLock(primaryTerm, seqNo));
    }

    public Object toBasicObject() {
        String formattedStartTime = DATE_FORMATTER.format((TemporalAccessor)this.startTime);
        ImmutableList stepList = this.stages.map(StepExecutionSummary::toBasicObject);
        return OrderedImmutableMap.ofNonNull((Object)FIELD_START_TIME, (Object)formattedStartTime, (Object)FIELD_STATUS, (Object)this.status.name().toLowerCase(), (Object)FIELD_TEMP_INDEX_NAME, (Object)this.tempIndexName, (Object)FIELD_BACKUP_INDEX_NAME, (Object)this.backupIndexName, (Object)FIELD_STAGES, (Object)stepList);
    }

    public boolean isSuccessful() {
        return ExecutionStatus.SUCCESS.equals((Object)this.status);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MigrationExecutionSummary that = (MigrationExecutionSummary)o;
        return Objects.equals(this.startTime, that.startTime) && this.status == that.status && Objects.equals(this.tempIndexName, that.tempIndexName) && Objects.equals(this.backupIndexName, that.backupIndexName) && Objects.equals(this.stages, that.stages);
    }

    @Override
    public int hashCode() {
        return Objects.hash(new Object[]{this.startTime, this.status, this.tempIndexName, this.backupIndexName, this.stages});
    }

    private Duration age(LocalDateTime now) {
        return Duration.between(this.startTime, now);
    }

    public boolean isMigrationInProgress(LocalDateTime now) {
        Objects.requireNonNull(now, "Current time is required to private data migration life span.");
        if (ExecutionStatus.SUCCESS.equals((Object)this.status) || ExecutionStatus.FAILURE.equals((Object)this.status)) {
            return false;
        }
        Duration age = this.age(now);
        return age.minus(DURATION_AGE_THRESHOLD).isNegative();
    }
}

